% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process1KG_internal.R
\encoding{UTF-8}
\name{validateGenerateGDS1KG}
\alias{validateGenerateGDS1KG}
\title{Validate input parameters for generateGDS1KG() function}
\usage{
validateGenerateGDS1KG(
  pathGeno,
  filePedRDS,
  fileSNVIndex,
  fileSNVSelected,
  fileNameGDS,
  listSamples,
  verbose
)
}
\arguments{
\item{pathGeno}{a \code{character} string representing the path where
the 1K genotyping files for each sample are located. The name of the
genotyping files must correspond to
the individual identification (Individual.ID) in the pedigree file.}

\item{filePedRDS}{a \code{character} string representing the path and file
name of the RDS file that contains the pedigree information. The file must
exist. The file must be a RDS file.}

\item{fileSNVIndex}{a \code{character} string representing the path and file
name of the RDS file that contains the indexes of the retained SNPs. The
file must exist. The file must be a RDS file.}

\item{fileSNVSelected}{a \code{character} string representing the path and
file name of the RDS file that contains the filtered SNP information. The
file must exist. The file must be a RDS file.}

\item{fileNameGDS}{a \code{character} string representing the path and file
name of the GDS file that will be created. The GDS file will contain the
SNP information, the genotyping information and the pedigree information
from 1000 Genomes.
The extension of the file must be '.gds'.}

\item{listSamples}{a \code{vector} of \code{character} string corresponding
to samples (must be the sample.ids) that will be retained and added to the
GDS file. When \code{NULL}, all the samples are retained.}

\item{verbose}{a \code{logical} indicating if the function must print
messages when running.}
}
\value{
The integer \code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link{generateGDS1KG}} function.
}
\examples{

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## The RDS file containing the pedigree information
pedigreeFile <- file.path(dataDir, "PedigreeReferenceDemo.rds")

## The RDS file containing the indexes of the retained SNPs
snpIndexFile <- file.path(dataDir, "listSNPIndexes_Demo.rds")

## The RDS file containing the filtered SNP information
filterSNVFile <- file.path(dataDir, "mapSNVSelected_Demo.rds")

## Temporary GDS file containing 1KG information
gdsFile <- file.path(dataDir, "1KG_TEMP.gds")

## The validation should be successful
RAIDS:::validateGenerateGDS1KG(pathGeno=dataDir, filePedRDS=pedigreeFile,
    fileSNVIndex=snpIndexFile, fileSNVSelected=filterSNVFile,
    fileNameGDS=gdsFile, listSamples=NULL, verbose=FALSE)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
