% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateCreateStudy2GDS1KG}
\alias{validateCreateStudy2GDS1KG}
\title{Validate input parameters for createStudy2GDS1KG() function}
\usage{
validateCreateStudy2GDS1KG(
  pathGeno,
  pedStudy,
  fileNameGDS,
  batch,
  studyDF,
  listProfiles,
  pathProfileGDS,
  genoSource,
  verbose
)
}
\arguments{
\item{pathGeno}{a \code{character} string representing the path to the
directory containing the VCF output of SNP-pileup for each sample. The
SNP-pileup files must be compressed (gz files) and have the name identifiers
of the samples. A sample with "Name.ID" identifier would have an
associated SNP-pileup file called "Name.ID.txt.gz". The directory must
exist.}

\item{pedStudy}{a \code{data.frame} with those mandatory columns: "Name.ID",
"Case.ID", "Sample.Type", "Diagnosis", "Source". All columns must be in
\code{character} strings (no factor). The \code{data.frame}
must contain the information for all the samples passed in the
\code{listSamples} parameter. Only \code{filePedRDS} or \code{pedStudy}
can be defined.}

\item{fileNameGDS}{a \code{character} string representing the file name of
the Population Reference GDS file. The file must exist.}

\item{batch}{a single positive \code{integer} representing the current
identifier for the batch. Beware, this field is not stored anymore.}

\item{studyDF}{a \code{data.frame} containing the information about the
study associated to the analysed sample(s). The \code{data.frame} must have
those 3 columns: "study.id", "study.desc", "study.platform". All columns
must be in \code{character} strings (no factor).}

\item{listProfiles}{a \code{vector} of \code{character} string corresponding
to the profile identifiers that will have a GDS Sample file created. The
profile identifiers must be present in the "Name.ID" column of the RDS file
passed to the \code{filePedRDS} parameter.
If \code{NULL}, all profiles in the \code{filePedRDS} are selected.}

\item{pathProfileGDS}{a \code{character} string representing the path to
the directory where the Profile GDS files will be created.}

\item{verbose}{a \code{logical} indicating if message information should be
printed.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link{createStudy2GDS1KG}} function.
}
\examples{

## Path to the demo pedigree file is located in this package
dataDir <- system.file("extdata", package="RAIDS")

## Demo 1KG Population Reference GDS file
gds1KG <- file.path(dataDir, "PopulationReferenceDemo.gds")

## The data.frame containing the information about the study
## The 3 mandatory columns: "study.id", "study.desc", "study.platform"
## The entries should be strings, not factors (stringsAsFactors=FALSE)
studyInfo <- data.frame(study.id="Pancreatic.WES",
                study.desc="Pancreatic study",
                study.platform="WES",
                stringsAsFactors=FALSE)

## PED Study
ped <- data.frame(Name.ID=c("Sample_01", "Sample_02"),
            Case.ID=c("TCGA-H01", "TCGA-H02"),
            Sample.Type=c("DNA", "DNA"),
            Diagnosis=c("Cancer", "Cancer"), Source=c("TCGA", "TCGA"))

## The validation should be successful
RAIDS:::validateCreateStudy2GDS1KG(pathGeno=dataDir, pedStudy=ped,
            fileNameGDS=gds1KG, batch=1, studyDF=studyInfo,
            listProfiles=c("Sample_01", "Sample_02"),
            pathProfileGDS=dataDir,
            genoSource="snp-pileup", verbose=TRUE)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
