% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{generateGDSRefSample}
\alias{generateGDSRefSample}
\title{Initialization of the section related to the profile
information in the GDS file}
\usage{
generateGDSRefSample(gdsReference, dfPedReference, listSamples = NULL)
}
\arguments{
\item{gdsReference}{an object of class
\link[gdsfmt]{gds.class} (a GDS file), the opened GDS file.}

\item{dfPedReference}{a \code{data.frame} containing the information
related to the
samples. It must have those columns: "sample.id", "Name.ID", "sex",
"pop.group", "superPop" and "batch". All columns, except "sex" and batch",
are \code{character} strings. The "batch" and "sex" columns are
\code{integer}. The unique identifier
of this \code{data.frame} is the "Name.ID" column. The row names of the
\code{data.frame} must correspond to the identifiers present in the
"Name.ID" column.}

\item{listSamples}{a \code{vector} of \code{character} string representing
the identifiers of the selected profiles. If \code{NULL}, all profiles are
selected. Default: \code{NULL}.}
}
\value{
a \code{vector} of \code{character} string with the identifiers of
the profiles saved in the GDS file.
}
\description{
This function initializes the section related to the profile
information in the GDS file. The information is extracted from
the \code{data.frame} passed to the function. The nodes "sample.id" and
"sample.annot" are created in the GDS file.
}
\examples{

## Required library
library(gdsfmt)

## Temporary GDS file in current directory
gdsFilePath <- file.path(tempdir(), "GDS_TEMP_10.gds")

## Create and open the GDS file
tmpGDS  <- createfn.gds(filename=gdsFilePath)

## Create "sample.annot" node (the node must be present)
pedInformation <- data.frame(sample.id=c("sample_01", "sample_02"),
        Name.ID=c("sample_01", "sample_02"),
        sex=c(1,1),  # 1:Male  2: Female
        pop.group=c("ACB", "ACB"),
        superPop=c("AFR", "AFR"),
        batch=c(1, 1),
        stringsAsFactors=FALSE)

## The row names must be the sample identifiers
rownames(pedInformation) <- pedInformation$Name.ID

## Add information about 2 samples to the GDS file
RAIDS:::generateGDSRefSample(gdsReference=tmpGDS,
        dfPedReference=pedInformation, listSamples=NULL)

## Read sample identifier list
read.gdsn(index.gdsn(node=tmpGDS, path="sample.id"))

## Read sample information from GDS file
read.gdsn(index.gdsn(node=tmpGDS, path="sample.annot"))

## Close GDS file
closefn.gds(gdsfile=tmpGDS)

## Delete the temporary GDS file
unlink(x=gdsFilePath, force=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
