% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelicFraction_internal.R
\encoding{UTF-8}
\name{computeAllelicFractionRNA}
\alias{computeAllelicFractionRNA}
\title{Estimate the allelic fraction of the pruned SNVs for a specific
RNA-seq sample}
\usage{
computeAllelicFractionRNA(
  gdsReference,
  gdsSample,
  gdsRefAnnot,
  currentProfile,
  studyID,
  blockID,
  chrInfo,
  minCov = 10L,
  minProb = 0.999,
  eProb = 0.001,
  cutOffLOH = -5,
  cutOffAR = 3,
  verbose
)
}
\arguments{
\item{gdsReference}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the opened Reference GDS file.}

\item{gdsSample}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the opened Profile GDS file.}

\item{gdsRefAnnot}{an object of class \code{\link[gdsfmt]{gds.class}}
(a GDS file), the opened Reference SNV Annotation GDS file.}

\item{currentProfile}{a \code{character} string corresponding to
the sample identifier as used in \code{\link{pruningSample}} function.}

\item{studyID}{a \code{character} string corresponding to the name of
the study as
used in \code{\link{pruningSample}} function.}

\item{blockID}{a \code{character} string corresponding to the field gene
block in the GDS \code{gdsRefAnnot} to use split by gene.}

\item{chrInfo}{a \code{vector} of \code{integer} values representing
the length of the chromosomes.}

\item{minCov}{a single positive \code{integer} representing the minimum
required coverage. Default: \code{10L}.}

\item{minProb}{a single \code{numeric} between \code{0} and \code{1}
representing the probability that the calculated genotype call is correct.
Default: \code{0.999}.}

\item{eProb}{a single \code{numeric} between 0 and 1 representing the
probability of sequencing error. Default: \code{0.001}.}

\item{cutOffLOH}{a single \code{numeric} log of the score to be LOH.
Default: \code{-5}.}

\item{cutOffAR}{a single \code{numeric} representing the cutoff, in
log score, to tag SNVs located in a gene has having an allelic fraction
different 0.5
Default: \code{3}.}

\item{verbose}{a \code{logicial} indicating if the function should print
message when running.}
}
\value{
a \code{data.frame} containing the allelic information for the
pruned SNV dataset with coverage > \code{minCov}. The \code{data.frame}
contains those columns:
\describe{
\item{cnt.tot}{ a \code{integer} representing the total allele count}
\item{cnt.ref}{ a \code{integer} representing the reference allele count}
\item{cnt.alt}{ a \code{integer} representing the alternative allele count}
\item{snp.pos}{ a \code{integer} representing the position on the chromosome}
\item{snp.chr}{ a \code{integer} representing the chromosome}
\item{normal.geno}{ a \code{integer} representing the genotype
(0=wild-type reference; 1=heterozygote; 2=homozygote alternative; 3=unkown)}
\item{pruned}{ a \code{logical} indicating if the SNV is retained after
pruning}
\item{snp.index}{ a \code{integer} representing the index position of the
SNV in the Reference GDS file that contains all SNVs}
\item{keep}{ a \code{logical} indicating if the genotype exists for the SNV}
\item{hetero}{ a \code{logical} indicating if the SNV is heterozygote}
\item{homo}{ a \code{logical} indicating if the SNV is homozygote}
\item{block.id}{ a \code{integer} indicating the unique identifier of the
block in the Population Reference Annotation
GDS file that contains the current SNV}
\item{phase}{ a \code{integer} indicating the phase of the variant
if known, \code{3} if not known}
\item{lap}{ a \code{numeric} indicating lower allelic fraction}
\item{LOH}{ a \code{integer} indicating if the SNV is in an LOH region
(0=not LOH, 1=in LOH)}
\item{imbAR}{ a \code{integer} indicating if the SNV is in an imbalanced
region (-1=not classified as imbalanced or LOH, 0=in LOH; 1=tested
positive for imbalance in at least 1 window)}
\item{freq}{ a \code{numeric} indicating the frequency of the variant
in the the reference}
}
}
\description{
The function creates a \code{data.frame} containing the
allelic fraction for the pruned SNV dataset specific to a RNA-seq sample.
}
\examples{

## Required library for GDS
library(SNPRelate)

#' ## Path to the demo 1KG GDS file is located in this package
dataDir <- system.file("extdata/tests", package="RAIDS")
fileGDS <- file.path(dataDir, "ex1_good_small_1KG.gds")
fileAnnotGDS <- file.path(dataDir, "ex1_good_small_1KG_Annot.gds")

## Temporary Profile GDS file for one profile in temporary directory
fileProfile <- file.path(tempdir(), "ex1.gds")

## Copy the Profile GDS file demo that has been pruned and annotated
file.copy(file.path(dataDir, "ex1_demo_with_pruning_and_1KG_annot.gds"),
                 fileProfile)

## Open the reference GDS file (demo version)
gds1KG <- snpgdsOpen(fileGDS)
gdsRefAnnot <- openfn.gds(fileAnnotGDS)

## Open Profile GDS file for one profile
profileGDS <- openfn.gds(fileProfile)

## Required library for this example to run correctly
if (requireNamespace("Seqinfo", quietly=TRUE) &&
     requireNamespace("BSgenome.Hsapiens.UCSC.hg38", quietly=TRUE)) {

    ## Chromosome length information
    ## chr23 is chrX, chr24 is chrY and chrM is 25
    chrInfo <- Seqinfo::seqlengths(BSgenome.Hsapiens.UCSC.hg38::Hsapiens)[1:25]

    ## The function returns a data frame containing the allelic fraction info
    result <- RAIDS:::computeAllelicFractionRNA(gdsReference=gds1KG,
        gdsSample=profileGDS, gdsRefAnnot=gdsRefAnnot,
        currentProfile="ex1", studyID="MYDATA",
        blockID="GeneS.Ensembl.Hsapiens.v86",
        chrInfo=chrInfo, minCov=10L, minProb=0.999, eProb=0.001,
        cutOffLOH=-5, cutOffAR=3, verbose=FALSE)
    head(result)

    ## Close both GDS files (important)
    closefn.gds(profileGDS)
    closefn.gds(gds1KG)
    closefn.gds(gdsRefAnnot)

    ## Remove Profile GDS file (created for demo purpose)
    unlink(fileProfile, force=TRUE)

}

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
