% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAIDS.R
\docType{package}
\encoding{UTF-8}
\name{RAIDS-package}
\alias{RAIDS-package}
\alias{RAIDS}
\title{RAIDS: Accurate Inference of Genetic Ancestry from Cancer Sequences}
\value{
RAIDS
}
\description{
The RAIDS package implements specialized algorithms that enable
ancestry inference from various cancer data sources (RNA,
Exome and Whole-Genome sequencing).
}
\details{
The RAIDS package also implements simulation algorithm that generates
synthetic cancer-derived data.

This code and analysis pipeline was designed and developed for the
following publication:

Pascal Belleau, Astrid Deschênes, Nyasha Chambwe, David A. Tuveson,
Alexander Krasnitz; Genetic Ancestry Inference from Cancer-Derived
Molecular Data across Genomic and Transcriptomic Platforms.
Cancer Res 1 January 2023; 83 (1): 49–58.
https://doi.org/10.1158/0008-5472.CAN-22-0682
}
\references{
Pascal Belleau, Astrid Deschênes, Nyasha Chambwe, David A. Tuveson,
Alexander Krasnitz; Genetic Ancestry Inference from Cancer-Derived
Molecular Data across Genomic and Transcriptomic Platforms.
Cancer Res 1 January 2023; 83 (1): 49–58.
https://doi.org/10.1158/0008-5472.CAN-22-0682
}
\seealso{
\describe{
\item{\code{\link{runExomeAncestry}}}{This function runs most steps
leading to the ancestry inference call on a specific exome profile.}
\item{\code{\link{runExomeAncestry}}}{This function runs most steps
leading to the ancestry inference call on a specific RNA profile.}
\item{\code{\link{createAccuracyGraph}}}{The function extracts the
required information from an output generated by RAIDS to create a
graphic representation of the accuracy for different values of
PCA dimensions and K-neighbors through all tested ancestries.}
}
}
\author{
Pascal Belleau, Astrid Deschênes and
Alexander Krasnitz

Maintainer:
Pascal Belleau \href{mailto:pascal_belleau@hotmail.com}{pascal_belleau@hotmail.com}
}
\keyword{internal}
\keyword{package}
