% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic_internal.R
\encoding{UTF-8}
\name{validatePepSynthetic}
\alias{validatePepSynthetic}
\title{Validate input parameters for prepSynthetic() function}
\usage{
validatePepSynthetic(
  fileProfileGDS,
  listSampleRef,
  profileID,
  studyDF,
  nbSim,
  prefix,
  verbose
)
}
\arguments{
\item{fileProfileGDS}{a \code{character} string representing the file name
of the GDS Sample file containing the information about the sample
used to generate the synthetic profiles.}

\item{listSampleRef}{a \code{vector} of \code{character} string
representing the
identifiers of the selected 1KG samples that will be used as reference to
generate the synthetic profiles.}

\item{profileID}{a \code{character} string representing the profile
identifier present in the \code{fileProfileGDS} that will be used to
generate synthetic profiles.}

\item{studyDF}{a \code{data.frame} containing the information about the
study associated to the analysed sample(s). The \code{data.frame} must have
those 2 columns: "study.id" and "study.desc". Those 2 columns
must be in \code{character} strings (no factor). Other columns can be
present, such as "study.platform", but won't be used.}

\item{nbSim}{a single positive \code{integer} representing the number of
simulations per combination of sample and 1KG reference.}

\item{prefix}{a single \code{character} string representing the prefix that
is going to be added to the name of the synthetic profile. The prefix
enables the creation of multiple synthetic profile using the same
combination of sample and 1KG reference.}

\item{verbose}{a \code{logical} indicating if messages should be printed
to show how the different steps in the function.}
}
\value{
\code{0L} when successful.
}
\description{
This function validates the input parameters for the
\code{\link[=prepSynthetic]{prepSynthetic()}} function.
}
\examples{

## Directory where demo GDS files are located
dataDir <- system.file("extdata", package="RAIDS")

## The Profile GDS Sample
gdsSample <- file.path(dataDir, "GDS_Sample_with_study_demo.gds")

## The study data frame
studyDF <- data.frame(study.id="MYDATA.Synthetic",
    study.desc="MYDATA synthetic data", study.platform="PLATFORM",
    stringsAsFactors=FALSE)

## The validation should be successful
RAIDS:::validatePepSynthetic(fileProfileGDS=gdsSample,
     listSampleRef=c("Sample01", "Sample02"), profileID="A101TCGA",
     studyDF=studyDF, nbSim=1L, prefix="TCGA", verbose=TRUE)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
