% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validatePEDStudyParameter}
\alias{validatePEDStudyParameter}
\title{Validate that the PED study has the mandatory columns}
\usage{
validatePEDStudyParameter(pedStudy)
}
\arguments{
\item{pedStudy}{a \code{data.frame} with those mandatory columns: "Name.ID",
"Case.ID", "Sample.Type", "Diagnosis", "Source". All columns must be in
\code{character} strings (no factor).}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function validates the input PED study. The PED study
must be a \code{data.frame} with those mandatory columns: "Name.ID",
"Case.ID", "Sample.Type", "Diagnosis", "Source". All columns must be in
\code{character} strings (no factor).
}
\examples{

## Pedigree Study data frame
ped <- data.frame(Name.ID=c("Sample_01", "Sample_02"),
            Case.ID=c("TCGA-H01", "TCGA-H02"),
            Sample.Type=c("DNA", "DNA"),
            Diagnosis=c("Cancer", "Cancer"), Source=c("TCGA", "TCGA"))

## Return 0L when PED is valid
RAIDS:::validatePEDStudyParameter(pedStudy=ped)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
