% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processStudy_internal.R
\encoding{UTF-8}
\name{validateComputeKNNRefSynthetic}
\alias{validateComputeKNNRefSynthetic}
\title{Validate the input parameters for computeKNNRefSynthetic()
function}
\usage{
validateComputeKNNRefSynthetic(
  gdsProfile,
  listEigenvector,
  listCatPop,
  studyIDSyn,
  spRef,
  fieldPopInfAnc,
  kList,
  pcaList
)
}
\arguments{
\item{gdsProfile}{an object of class
\code{\link[SNPRelate:SNPGDSFileClass]{SNPRelate::SNPGDSFileClass}}, the
opened Profile GDS file.}

\item{listEigenvector}{a \code{list} with 3 entries:
'sample.id', 'eigenvector.ref' and 'eigenvector'. The \code{list} represents
the PCA done on the 1KG reference profiles and the synthetic profiles
projected onto it.}

\item{listCatPop}{a \code{vector} of \code{character} string
representing the list of possible ancestry assignations.}

\item{studyIDSyn}{a \code{character} string corresponding to the study
identifier.
The study identifier must be present in the Profile GDS file.}

\item{spRef}{\code{vector} of \code{character} strings representing the
known super population ancestry for the 1KG profiles. The 1KG profile
identifiers are used as names for the \code{vector}.}

\item{fieldPopInfAnc}{a \code{character} string representing the name of
the column that will contain the inferred ancestry for the specified
dataset.}

\item{kList}{a \code{vector} of \code{integer} representing  the list of
values tested for the  K parameter. The K parameter represents the
number of neighbors used in the K-nearest neighbors analysis.}

\item{pcaList}{a \code{vector} of \code{integer} representing  the list of
values tested for the  D parameter. The D parameter represents the
number of dimensions used in the PCA analysis.}
}
\value{
The integer \code{0L} when successful.
}
\description{
The function validates the input parameters for the
\code{\link{computeKNNRefSynthetic}} function.
When a parameter is not as expected, an error message is generated.
}
\examples{

## Load the demo PCA on the synthetic profiles projected on the
## demo 1KG reference PCA
data(demoPCASyntheticProfiles)

## Load the known ancestry for the demo 1KG reference profiles
data(demoKnownSuperPop1KG)

## Path to the demo GDS file is located in this package
dataDir <- system.file("extdata/demoKNNSynthetic", package="RAIDS")
fileProfileGDS <- file.path(dataDir, "ex1.gds")

## Open GDS files
gdsProfile <- openfn.gds(fileProfileGDS)

## The function returns 0L when all parameters are valid
RAIDS:::validateComputeKNNRefSynthetic(gdsProfile=gdsProfile,
    listEigenvector=demoPCASyntheticProfiles,
    listCatPop=c("EAS", "EUR", "AFR", "AMR", "SAS"),
    studyIDSyn="MyStudy", spRef=demoKnownSuperPop1KG,
    fieldPopInfAnc="Superpop", kList=c(10, 11, 12),
    pcaList=c(13, 14, 15))

## Close GDS file (it is important to always close the GDS files)
closefn.gds(gdsProfile)


}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
