% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_internal.R
\encoding{UTF-8}
\name{validateAccuracyGraphInternal}
\alias{validateAccuracyGraphInternal}
\title{Validate input parameters for createAccuracyGraph and
createAUROCGraph functions}
\usage{
validateAccuracyGraphInternal(title, selectD, selectColor)
}
\arguments{
\item{title}{a \code{character} string representing the title of the graph.}

\item{selectD}{a \code{array} of \code{integer} representing the selected
PCA dimensions to plot. The length of the \code{array} cannot be more than
5 entries. The dimensions must tested by RAIDS (i.e. be present in the
RDS file).}

\item{selectColor}{a \code{array} of \code{character} strings representing
the selected colors for the associated PCA dimensions to plot. The length
of the \code{array} must correspond to the length of the \code{selectD}
parameter. In addition, the length of the \code{array} cannot be more than
5 entries.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates the parameters for the
\code{\link{createAccuracyGraph}} and \code{\link{createAUROCGraph}}
functions.
}
\examples{

## Validate parameters
RAIDS:::validateAccuracyGraphInternal(title="Accuracy Graph", 
    selectD=c(5, 10), selectColor=c("blue","darkblue"))
    
}
\author{
Astrid Deschênes and Pascal Belleau
}
\keyword{internal}
