% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdsWrapper_internal.R
\encoding{UTF-8}
\name{runIBDKING}
\alias{runIBDKING}
\title{Identity-by-descent (IBD) analysis}
\usage{
runIBDKING(gds, profileID = NULL, snpID = NULL, maf = 0.05, verbose)
}
\arguments{
\item{gds}{an object of class
\code{\link[SNPRelate:SNPGDSFileClass]{SNPRelate::SNPGDSFileClass}}, an
opened SNP GDS file.}

\item{profileID}{a \code{vector} of \code{character} strings representing
the samples to keep for the analysis. If \code{NULL}, all samples are used.
Default: \code{NULL}.}

\item{snpID}{a \code{vector} of \code{character} strings representing
the SNPs to keep for the analysis. If \code{NULL}, all SNPs are used.
Default: \code{NULL}.}

\item{maf}{a single \code{numeric} representing the threshold for the minor
allele frequency. Only the SNPs with ">= maf" are retained.
Default: \code{0.05}.}

\item{verbose}{a \code{logical} indicating if information is shown during
the process in the \code{\link[SNPRelate]{snpgdsIBDKING}}() function.}
}
\value{
a \code{list} containing:
\describe{
\item{sample.id}{a \code{character} string representing the sample
ids used in the analysis}
\item{snp.id}{a \code{character} string representing the SNP ids
used in the analysis}
\item{k0}{a \code{numeric}, the IBD coefficient, the probability of
sharing zero IBD}
\item{k1}{a \code{numeric}, the IBD coefficient, the probability of
sharing one IBD}
\item{IBS0}{a \code{numeric}, the proportion of SNPs with zero IBS}
\item{kinship}{a \code{numeric}, the proportion of SNPs with zero IBS,
if the parameter kinship=TRUE}
}
}
\description{
This function calculates the IDB coefficients by KING method
of moment using the
\code{\link[SNPRelate:snpgdsIBDKING]{SNPRelate::snpgdsIBDKING}}
function.
}
\examples{

## Required
library(SNPRelate)

## Open an example dataset (HapMap)
genoFile <- snpgdsOpen(snpgdsExampleFileName())

## Extract CEU population
samples <- read.gdsn(index.gdsn(genoFile, "sample.id"))
CEU <- samples[
    read.gdsn(index.gdsn(genoFile, "sample.annot/pop.group"))=="CEU"]

## Infer the presence of population stratification
ibd.robust <- RAIDS:::runIBDKING(gds=genoFile, profileID=CEU, snpID=NULL,
     maf=0.05, verbose=FALSE)

## close the genotype file
snpgdsClose(genoFile)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
