% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_internal.R
\encoding{UTF-8}
\name{processPileupChrBin}
\alias{processPileupChrBin}
\title{Extract SNV information from pileup file for a selected chromosome}
\usage{
processPileupChrBin(chr, resPileup, varDf, verbose)
}
\arguments{
\item{chr}{a \code{character} string representing the name of the
chromosome to keep}

\item{resPileup}{a \code{data.frame} as generated by the \code{pileup}
function from \code{Rsamtools} package}

\item{varDf}{a \code{list} containing a \code{data.frame} representing
the positions to keep for each chromosome.}

\item{verbose}{a \code{logical} indicating if messages should be printed}
}
\value{
a \code{data.frame} containing at least:
\describe{
\item{seqnames}{ a \code{character} representing the name of the chromosome}
\item{pos}{ a \code{numeric} representing the position on the chromosome}
\item{REF}{ a \code{character} string representing the reference nucleotide}
\item{ALT}{ a \code{character} string representing the alternative
nucleotide}
\item{A}{ a \code{numeric} representing the count for the A nucleotide}
\item{C}{ a \code{numeric} representing the count for the C nucleotide}
\item{G}{ a \code{numeric} representing the count for the G nucleotide}
\item{T}{ a \code{numeric} representing the count for the T nucleotide}
\item{count}{ a \code{numeric} representing the total count}
}
}
\description{
The function reads pileup file and
returns a \code{data.frame}
containing the information about the read counts for the SNVs present in
the selected chromosome.
}
\examples{

## Demo pileup result data.frame
resDemo <- data.frame(seqnames=rep("chr14", 10),
    pos=c(19069583, 19069584, 19069586, 19069588, 19069589, 19069590,
            19069591, 19069592, 19069609, 19069760),
    strand=c(rep("+", 5), rep("-", 5)),
    nucleotide=c("T", "G", "G", "C", "A", "A", "C", "T", "T", "G"),
    count=c(5, 3, 2, 4, 1, 2, 1, 8, 7, 4))
resDemo$seqnames <- factor(resDemo$seqnames)
resDemo$strand <- factor(resDemo$strand)
resDemo$nucleotide <- factor(resDemo$nucleotide)

## Position to keep in a data.frame format
varInfo <- list("chr14"=data.frame(chr=c("chr14", "chr14"),
    start=c(19069584, 19069609), REF=c("A", "G"), ALT=c("T", "A")))

## Extract information from pileup for selected positions
RAIDS:::processPileupChrBin(chr="chr14", resPileup=resDemo, varDf=varInfo,
    verbose=FALSE)

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
