\name{loadPETs-methods}
\docType{methods}
\alias{loadPETs}
\alias{loadPETs-methods}
\alias{loadPETs,ChiapetExperimentData,character-method}
\title{ Parsing  ChIA-PET interaction data}
\description{
This method loads the ChIA-PET interactions data into a \code{\linkS4class{GRanges}} object from a file generated by ChIA-PET tool or an already formatted BED file.
}
\usage{
\S4method{loadPETs}{ChiapetExperimentData,character}(object, petFile, IsBed=TRUE, header=TRUE, dist=1000)
}
\arguments{
\item{object}{
   (\strong{Required})  a \code{\link{ChiapetExperimentData}} object
  }
\item{petFile}{
 (\strong{Required}) path to the file to parse. two types of formats are accepted. If the file comes from the ChIA-PET tool or has the same format used in the ENCODE project 
 \preformatted{
  chromleft startleft endleft chromright startright endright
      chr1    872113  879175       chr1     933836   938416     
      chr1    874165  879175       chr1     933340   938306     
      chr1    889676  896594       chr1     933897   938982     
      chr1    898753  907581       chr1     931133   939571     
      chr1    910103  918775       chr1     930834   938627     
      chr1    919314  922154       chr1     934212   937864      
}

only the the coordinates of the left and the right regions are considered (which means the first 6 columns), 
The additional columns are just ignored. We suppose that the user has already selected the interactions
that sound significant for him.

if this kind of file is provided the \code{IsBed} parameter should be set to \code{FASLE}. if the file has no header the user
needs to set \code{header=FALSE}.

if \code{IsBed} parameter is provided, the provided file should have 4 columns, three to describe the region location 
and the forth column to indicate the ID of the interaction and its position (1: for left and 2: for  right), 
according to following pattern \code{PET#\\d\\.1} or \code{PET#\\d\\.2}.
\preformatted{
      	chr1	  1241234	  1242234	PET#1.1
      	chr1	  1242724	  1243724	PET#1.2
      	chr1	  1282708	  1283708	PET#2.1
      	chr1	  1283834	  1284834	PET#2.2
      	chr1	  1370871	  1371871	PET#3.1
      	chr1	  1372322	  1373322	PET#3.2
}
  }
\item{IsBed}{
  (\emph{optional}) The flag indicates whether the provided file has a 4 columns BED (when \code{IsBed = TRUE} ) format or has the ChIA-PET tool format (when \code{IsBed = FALSE}). By default, \code{IsBed = TRUE}
  }
\item{header}{
 
 (\emph{optional}) Indicates whether or not the first line of the file should be considered as a header. by default it is \code{TRUE}
  }
\item{dist}{
  
  (\emph{optional}) This parameter indicates the size of the up- and down-stream regions \emph{(in bp)} to consider around the center of each region.
	3CPET is based on the assumption  that the real ChIP-Seq signal is more enriched around the center of the regions and get more depleted when moving further in both directions. Thus, when the user provides a file that has a ChIA-PET tool format (\code{IsBed = TRUE}), 3CPET will first center the regions and consider only \code{distance} bp up- and down-stream of the center of each region. A default value of 1000bp is used.
  }
}
\value{
A \code{\link{ChiapetExperimentData}} object in which the \code{ppi} is populated as a \code{\linkS4class{GRanges}} object.
}
\references{
Li G, Fullwood MJ, Xu H et al.\emph{ChIA-PET tool for comprehensive chromatin interaction analysis with paired-end tag sequencing}. Genome Biology 2010, 11(2):R22

Mohamed Nadhir D, Yang C et al \emph{3CPET: Finding Co-factor Complexes in Chia-PET experiment using a Hierarchical Dirichlet Process}, ....
}
\author{
Mohamed Nadhir Djekidel (\email{nde12@mails.tsinghua.edu.cn})
}
\seealso{
\code{\link{ChiapetExperimentData}}, \code{\link{loadTFBS}} , \code{\link{loadPPI}}, \code{\link{createIndexes}}
}
\examples{
## Create a ChiapetExperimentData object
x <- ChiapetExperimentData(ppiType= "HPRD")

## load the different datasets (where the file has a Chia-PET tool format )
petFile <- file.path(system.file("example",package="R3CPET"),"HepG2_interactions.txt")
x <- loadPETs(x, petFile=petFile, IsBed=FALSE)

## when loading an already formatted BED file
petFile <- file.path(system.file("example",package="R3CPET"),"HepG2_centered.bed")
x <- loadPETs(x, petFile=petFile, IsBed=TRUE, header=FALSE)

pet(x)
}
\keyword{methods}
