\name{HLDAResult-class}
\Rdversion{1.1}
\docType{class}
\alias{HLDAResult-class}
\alias{HLDAResult}
\alias{wordsPerTopic}
\alias{wordsPerTopic-methods}
\alias{wordsPerTopic,HLDAResult-method}
\alias{docPerTopic}
\alias{docPerTopic-methods}
\alias{docPerTopic,HLDAResult-method}
\alias{betas}
\alias{betas-methods}
\alias{betas,HLDAResult-method}

\title{Class \code{"HLDAResult"}}
\description{
 This class is a container for the results generated by the HLDA algorithm
}
\usage{
 HLDAResult(docPerTopic,wordsPerTopic ,betas)
}
\arguments{
    \item{docPerTopic}{Object of class \code{"matrix"} describing the partnership of each document in a topic.
    In our case a documents is the protein interaction networks associated with each DNA interaction 
    and the topics are the inferred chromatin maintainer networks.}
    \item{wordsPerTopic}{Object of class \code{"matrix"} describing the partnership of each word to a topic.
    In our case a word is an edge and the topics are the chromatin maintainer networks. }
    \item{betas}{Object of class \code{"numeric"} the beta values for each network. 
    Basically, it shows how popular is the network.}
}
\section{Accessors}{
For a given \code{HLDAResult} object the following accesor functions can be used:
\describe{
\item{\code{docPerTopic(x)}}{ gets the content of the \code{docPerTopic} matrix.}
\item{\code{wordsPerTopic(x)}}{ gets the content of the \code{wordsPerTopic} matrix.}
\item{\code{betas(x)}}{ gets the \code{betas} values.}
}
}

\value{
  an \code{HLDAResult} object.
}
\references{
Chong Wang, John Paisley and David M. Blei, \emph{Online variational inference for the hierarchical Dirichlet process}
.In AISTATS 2011

Mohamed Nadhir D, Yang C et al, \emph{3CPET: Finding Co-factor Complexes in Chia-PET experiment using a Hierarchical Dirichlet Process}, ....
}
\author{
Mohamed Nadhir Djekidel (\email{nde12@mails.tsinghua.edu.cn})
}
\seealso{
\code{\link{NetworkCollection}}, \code{\link{ChromMaintainers}} , \code{\link{InferNetworks}}
}
\examples{
showClass("HLDAResult")
}
\keyword{classes}
