% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mash_2_qtle.R
\docType{methods}
\name{QTLe-coerce}
\alias{QTLe-coerce}
\alias{mash2qtle}
\alias{.mashData_2_qtle}
\alias{.mashFit_2_qtle}
\title{Coercing mash data objects into QTLe objects}
\usage{
mash2qtle(data, sep = NULL, rowData = NULL, verbose = FALSE)

.mashData_2_qtle(data)

.mashFit_2_qtle(data)
}
\arguments{
\item{data}{A mashr object output from mash_set_data() or mash() from mashr.}

\item{sep}{String separating the feature_id from the variant_id in the row.names of the mashr object}

\item{rowData}{if feature_id and variant_id are not in the row.names, a rowData matrix can be provided with this information.}

\item{verbose}{Logical.}
}
\value{
A \linkS4class{QTLExperiment} object.
}
\description{
Function to coerce a mashr object (class list or mashr) into a QTLe object.
}
\examples{
nStates <- 6
nQTL <- 40
mashr_sim <- mockMASHR(nStates, nQTL)

qtle2 <- mash2qtle(
    mashr_sim,
    rowData=DataFrame(
        feature_id=row.names(mashr_sim$Bhat),
        variant_id=sample(seq_len(nQTL))))
dim(qtle2)


}
\author{
Christina B Azodi, Amelia Dunstone
}
