% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_missing_data.R
\name{replace_missing_data}
\alias{replace_missing_data}
\title{Replace missing data with median ± random noise}
\usage{
replace_missing_data(dat, noise_pct = 0.05)
}
\arguments{
\item{dat}{the data frame to replace missing data in}

\item{noise_pct}{the standard deviation of the random normal 
distribution from which to draw added noise, expressed as a 
percentage of the standard deviation of the non-missing values in each 
column}
}
\value{
a data frame with missing values in each numeric column replaced
by the column median, plus or minus some random noise
}
\description{
Replace missing data within each numeric column of a data frame with 
the column median, plus or minus some random noise, in order to train 
classifiers that do not easily ignore missing data (e.g. random forests or
support vector machines).
}
