% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_feature_from_expression.R
\name{make_feature_from_expression}
\alias{make_feature_from_expression}
\title{Create a feature vector from expression data}
\usage{
make_feature_from_expression(expr, dat, node_columns = c(1, 2), ...)
}
\arguments{
\item{expr}{a matrix containing gene or protein expression data, with 
genes/proteins in columns and samples in rows}

\item{dat}{the data frame of features to be used by the classifier, 
with protein pairs in the columns specified by the \code{node_columns}
argument}

\item{node_columns}{a vector of length two, denoting either the indices 
(integer vector) or column names (character vector) of the columns within 
the data frame containing the nodes participating in pairwise interactions;
defaults to the first two columns of the data frame (\code{c(1, 2)})}

\item{...}{arguments passed to \code{cor}}
}
\value{
a vector matching the dimensions and order of the feature data frame,
to use as input for a classifier in interaction prediction
}
\description{
Convert a gene or protein expression matrix into a feature vector
that matches the dimensions of a data frame used as input to a classifier, 
such as a naive Bayes, random forests, or support vector machine classifier,
by calculating the correlation between each pair of genes or proteins.
}
