% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatTestPaired.R
\name{PolySTest_paired}
\alias{PolySTest_paired}
\title{PolySTest for Paired Tests}
\usage{
PolySTest_paired(
  fulldata,
  allComps,
  statTests = c("limma", "Miss_Test", "t_test", "rank_products", "permutation_test")
)
}
\arguments{
\item{fulldata}{A \code{SummarizedExperiment} or derived object containing
the quantitative data required for PolySTest analysis.}

\item{allComps}{A matrix specifying pairs of conditions to compare.
Each row represents a pair for comparison.}

\item{statTests}{A character vector specifying the statistical tests to
be applied. Available tests include "limma", "Miss_Test",
"t-test", "rank_products", and "permutation_test". The
function
will perform each specified test and integrate the results.}
}
\value{
A \code{SummarizedExperiment} object augmented with p-values and q-values
in its \code{rowData}, reflecting the outcomes of the specified
statistical analyses.
}
\description{
Integrates various statistical tests for analyzing paired data within
a \code{SummarizedExperiment} framework. It compares pairs of conditions
specified by the user to calculate p-values and q-values for each comparison.
}
\details{
Executes specified statistical tests on the dataset contained in
\code{fulldata} using the condition pairs outlined in \code{allComps}.
Calculates p-values and q-values for each genomic feature (e.g.,
genes, proteins) included in the analysis. Results are added to the
\code{rowData} of the
\code{SummarizedExperiment} object, enhancing it with detailed statistics
from the paired tests.
}
\examples{
library(SummarizedExperiment)

# Mock quantitative data and metadata for samples
quantData <- matrix(rnorm(2000), nrow = 200, ncol = 10)
colnames(quantData) <- c(
    paste("Sample", 1:5, "_Condition_A", sep = ""),
    paste("Sample", 1:5, "_Condition_B", sep = "")
)
rownames(quantData) <- paste("Gene", 1:200)
sampleMetadata <- data.frame(Condition = rep(c("A", "B"), each = 5))

# Creating the SummarizedExperiment object
fulldata <- SummarizedExperiment(
    assays = list(quant = quantData),
    colData = sampleMetadata
)
metadata(fulldata) <- list(NumReps = 5, NumCond = 2)

# Specifying pairs of conditions to compare
allComps <- matrix(c("A", "B"), ncol = 2, byrow = TRUE)

# Specify statistical tests to apply
statTests <- c("limma", "t_test", "rank_products")

# Running PolySTest for paired comparisons
results <- PolySTest_paired(fulldata, allComps, statTests)

}
