% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importSampleSheet.R
\name{importSampleSheet}
\alias{importSampleSheet}
\title{importSampleSheet}
\usage{
importSampleSheet(
  sampleSheet = NULL,
  well_id = NULL,
  software = c("QuantaSoft", "QX Manager")[2],
  targetChannel = c(1, 2, 3, 4, 5, 6)[1],
  controlChannel = c(1, 2, 3, 4, 5, 6)[2]
)
}
\arguments{
\item{sampleSheet}{Path to sample sheet file containing information about
samples.}

\item{well_id}{Character vector with well IDs corresponding to uploaded
amplitude files.}

\item{software}{Name (character) of software data and sample sheet was
exported from. Must be either 'QuantaSoft' or 'QX Manager'. Be careful
to use correct spelling.}

\item{targetChannel}{The channel nr used as target channel (default=1)}

\item{controlChannel}{The channel nr used as control channel (default=2)}
}
\value{
A data.frame with columns for sample ID, target assay and control
    assay.
}
\description{
Function that takes a path to a .csv-file containing information
    about the samples that correspond to the uploaded amplitude files. This
    file must contain the following columns: Well, Sample, TargetType
    and Target. A character vector with well IDs must also be provided,
    which is used to match rows in sample sheet to amplitude files
}
\examples{
## Path to example sample sheet included in PoDCall
path <- system.file("extdata", "Sample_names.csv", package="PoDCall")

## Select wells to get information for
well_id <- c("A04", "B04", "D04")

## Get information for selected wells
sampleSheet <- importSampleSheet(sampleSheet=path, well_id=well_id,
                                 software="QuantaSoft")

}
