% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFastaSeqs.R
\name{getFastaFromFasInput}
\alias{getFastaFromFasInput}
\title{Get fasta sequences from main input file in multi-fasta format}
\usage{
getFastaFromFasInput(seqIDs = NULL, file = NULL)
}
\arguments{
\item{seqIDs}{list of sequences IDs. Set seqIDs = "all" if you want to get
all fasta sequences from the input file.}

\item{file}{raw phylogenetic profile input file in multi-fasta format.}
}
\value{
A dataframe with one column contains sequences in fasta format.
}
\description{
Get fasta sequences from main input file in multi-fasta format
}
\examples{
file <- system.file(
    "extdata", "test.main.fasta",
    package = "PhyloProfile", mustWork = TRUE
)
getFastaFromFasInput("all", file)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
