% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDomainPlot.R
\name{createArchiPlot}
\alias{createArchiPlot}
\title{Create protein's domain architecure plot}
\usage{
createArchiPlot(info, domainDf, labelArchiSize, titleArchiSize,
    legendArchiSize, showScore, showWeight, namePosition, firstDist, 
    nameType, nameSize, segmentSize, nameColor, labelPos, colorType, 
    ignoreInstanceNo, currentNCBIinfo, featureClassSort, featureClassOrder, 
    colorPalette, resolveOverlap, font)
}
\arguments{
\item{info}{A list contains seed and ortholog's IDs}

\item{domainDf}{Dataframe contains domain info for the seed and ortholog.
This including the seed ID, orthologs IDs, sequence lengths, feature names,
start and end positions, feature weights (optional) and the status to
determine if that feature is important for comparison the architecture
between 2 proteins* (e.g. seed protein vs ortholog) (optional).}

\item{labelArchiSize}{Lable size (in px). Default = 12.}

\item{titleArchiSize}{Title size (in px). Default = 12.}

\item{legendArchiSize}{Title size (in px). Default = 12.}

\item{showScore}{Show/hide E-values and Bit-scores. Default = NULL (hide)}

\item{showWeight}{Show/hide feature weights. Default = NULL (hide)}

\item{namePosition}{list of positions for domain names, choose from "plot",
"legend" or "axis". Default: "plot"}

\item{firstDist}{Distance of the first domain to plot title. Default = 0.5}

\item{nameType}{Type of domain names, either "Texts" or "Labels" (default)}

\item{nameSize}{Size of domain names. Default = 3}

\item{segmentSize}{Height of domain segment. Default = 5}

\item{nameColor}{Color of domain names (for Texts only). Default = "black"}

\item{labelPos}{Position of domain names (for Labels only). Choose from}

\item{colorType}{Choose to color "all", "shared", "unique" features or color
by "Feature type". Default = "all"}

\item{ignoreInstanceNo}{Ignore number of feature instances while identifying
shared or unique features. Default = FALSE}

\item{currentNCBIinfo}{Dataframe of the pre-processed NCBI taxonomy
data. Default = NULL (will be automatically retrieved from PhyloProfile app)}

\item{featureClassSort}{Choose to sort features. Default = "Yes"}

\item{featureClassOrder}{vector of ordered feature classes}

\item{colorPalette}{Choose between "Paired", "Set1", "Set2", "Set3",
"Accent", "Dark2" for the color pallete}

\item{resolveOverlap}{Choose to merge non-overlapped features of a feature
type into one line. Default = "Yes"}

\item{font}{font of text. Default = Arial"}
}
\value{
A domain plot as arrangeGrob object. Use grid::grid.draw(plot) to
render.
}
\description{
Create architecture plot for both seed and orthologous protein.
If domains of ortholog are missing, only architecture of seed protein will
be plotted. NOTE: seed protein ID is the one being shown in the profile plot,
which normally is also the orthologous group ID.
}
\examples{
seedID <- "101621at6656"
orthoID <- "101621at6656|AGRPL@224129@0|224129_0:001955|1"
info <- c(seedID, orthoID)
domainFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
domainDf <- parseDomainInput(seedID, domainFile, "file")
domainDf$feature_id_mod <- domainDf$feature_id
domainDf$feature_id_mod <- gsub("SINGLE", "LCR", domainDf$feature_id_mod)
domainDf$feature_id_mod[domainDf$feature_type == "coils"] <- "Coils"
domainDf$feature_id_mod[domainDf$feature_type == "seg"] <- "LCR"
domainDf$feature_id_mod[domainDf$feature_type == "tmhmm"] <- "TM"
plot <- createArchiPlot(info, domainDf, font = "sans")
grid::grid.draw(plot)
}
\seealso{
\code{\link{singleDomainPlotting}},\code{\link{pairDomainPlotting}},
\code{\link{sortDomains}}, \code{\link{parseDomainInput}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
