% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhIPData-class.R
\docType{class}
\name{PhIPData-class}
\alias{PhIPData-class}
\alias{.PhIPData}
\alias{PhIPData}
\title{The PhIPData class}
\usage{
PhIPData(
  counts = matrix(nrow = 0, ncol = 0),
  logfc = matrix(nrow = 0, ncol = 0),
  prob = matrix(nrow = 0, ncol = 0),
  peptideInfo = S4Vectors::DataFrame(),
  sampleInfo = S4Vectors::DataFrame(),
  metadata = list(),
  .defaultNames = "info"
)
}
\arguments{
\item{counts}{a \code{matrix}, \code{data.frame}, or
\code{\linkS4class{DataFrame}}of \strong{integer} read counts.}

\item{logfc}{a \code{matrix}, \code{data.frame}, or
\code{\linkS4class{DataFrame}} of log2 estimated fold changes.}

\item{prob}{a \code{matrix}, \code{data.frame}, or
\code{\linkS4class{DataFrame}} of probability values (p-values or
posterior probabilities) for enrichment estimates.}

\item{peptideInfo}{a \code{data.frame} or \code{\linkS4class{DataFrame}} of
peptide information.}

\item{sampleInfo}{a \code{data.frame} or \code{\linkS4class{DataFrame}} of
additional sample information.}

\item{metadata}{a \code{list} object containing experiment-specific metadata.}

\item{.defaultNames}{vector of names to use when sample and peptide
    identifiers disagree across the metadata and the \code{counts},
    \code{logfc}, and \code{prob} matrices. If \code{.defaultNames} is of
    length 1, the same source is used for both peptide and sample
    identifiers. If \code{.defaultNames} is longer than 2, the first and
    second elements correspond to the names for peptides and samples,
    respectively.

    Valid options are:
    \itemize{
        \item{"info": }{names should be taken from the \code{SampleInfo} or
            \code{peptideInfo} objects.}
        \item{"counts": }{names should be taken from the row/column names
            of the \code{counts} object.}
        \item{"logfc": }{names should be taken from the row/column names of
            the \code{logfc} object.}
        \item{"prob": }{names should be taken from the row/column names of
            the \code{prob} object.}
    }}
}
\value{
A \code{PhIPData} object.
}
\description{
The \code{PhIPData} class is a matrix-like container designed to organize
results from phage-immunoprecipitation (PhIP-Seq) experiments. Rows in
PhIPData objects represent peptides and columns represent samples. Each
object contains at least three assays:

\itemize{
    \item{\code{counts}:} a matrix of raw read counts,
    \item{\code{logfc}:} a matrix of log2 estimated fold-change in
         comparison to beads-only samples,
    \item{\code{prob}:} a matrix of probabilities associated with whether
         a sample has an enriched antibody response for a peptide.
}

The \code{PhIPData} class extends the
\linkS4class{RangedSummarizedExperiment} class, so methods documented
in \linkS4class{RangedSummarizedExperiment} and
\linkS4class{SummarizedExperiment} also work on \code{PhIPData} objects.
}
\details{
Rows of \code{PhIPData} objects correspond to peptides of interest and are
organized in \link{GRanges} or \link{GRangesList} objects. Though originally
designed for genomic ranges, the sequence name and genomic range information
in \link{GRanges} objects can be replaced with peptide names and amino acid
positions, respectively. If no peptide names are given, peptides are given
the names of \code{pep_rownum}. Peptide positions are specified by columns
\code{pos_start} and \code{pos_end} in the \code{peptideInfo} argument of the
constuctor. Missing position information is set to 0. Additional peptide
annotation can also be stored in \link{GRanges} objects and can be used
to subset \code{PhIPData} objects as shown below.

Columns of \code{PhIPData} objects represent samples. Sample metadata
are stored in a \link{DataFrame} and can be accessed as shown below. If no
sample names are specified, samples are given default names of
\code{sample_colnum}.

Unlike \link{RangedSummarizedExperiment}/\link{SummarizedExperiment} objects,
\code{PhIPData} objects must contain \code{counts}, \code{logfc},
\code{prob}. If any of the three assays are missing when the constructor is
called, an empty matrix of the same names and dimensions is initialized for
that assay. Sample and peptide names are harmonized across assays and
annotation during construction and replacement.

Though `counts` typically contain integer values for the number of reads
aligned to each peptide, `PhIPData` only requires that stored values are
non-negative numeric values. Pseudocounts or non-integer count values can
also be stored in the `counts` assay.
}
\section{Constructor}{

\code{PhIPData} objects are constructed using the homonymous function and
arguments as described above. Any \code{PhIPData} object can be created
so long as peptide and sample identifiers (or lack thereof) are specified
via any of the parameters.
}

\examples{
## Construct a new PhIPData object
counts_dat <- matrix(sample(1:1e6, 25, replace = TRUE), nrow = 5)
logfc_dat <- matrix(rnorm(25, 0, 10), nrow = 5)
prob_dat <- matrix(rbeta(25, 1, 1), nrow = 5)

peptide_meta <- data.frame(
    pos_start = 1:5,
    pos_end = 6:10,
    species = c(rep("HIV", 3), rep("EBV", 2))
)
sample_meta <- data.frame(
    gender = sample(c("M", "F"), 5, TRUE),
    group = sample(c("ctrl", "trt", "beads"), 5, TRUE)
)
exp_meta <- list(
    date_run = as.Date("2021/01/20"),
    reads_per_sample = colSums(counts_dat)
)

rownames(counts_dat) <- rownames(logfc_dat) <-
    rownames(prob_dat) <- rownames(peptide_meta) <-
    paste0("pep_", 1:5)
colnames(counts_dat) <- colnames(logfc_dat) <-
    colnames(prob_dat) <- rownames(sample_meta) <-
    paste0("sample_", 1:5)

phip_obj <- PhIPData(
    counts_dat, logfc_dat, prob_dat,
    peptide_meta, sample_meta, exp_meta
)
phip_obj
}
\seealso{
\code{\link{PhIPData-methods}} for accessors and modifiers for PhIPData
     components.
     \linkS4class{SummarizedExperiment}
}
