% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTestwCor.R
\name{TTestwCor}
\alias{TTestwCor}
\title{Two-sample t-test accounting for inter-peptide correlation}
\usage{
TTestwCor(statistic, index, inter.pep.cor, pepC.estim = c("sd", "mad"))
}
\arguments{
\item{statistic}{a numeric vector of peptide-wise t-statistics.}

\item{index}{an index vector or a list of index vectors. \code{statistic[index]} selects corresponding rows
in the protein of interest, i.e., test set(s).}

\item{inter.pep.cor}{a numeric vector of inter-peptide correlation coefficients within
the protein of interest, i.e., test set(s).}

\item{pepC.estim}{estimator of the variance of peptide-wise t-statistics not
belonging to the protein of interest, i.e., test set. Options include "sd" and "mad".
"sd" represents sample standard deviation. "mad" represents sample median
absolute deviation.}
}
\value{
\code{TTestwCor} returns a dataframe in which each row represents a protein of
interest, i.e., test set. Columns include
\item{NPeps}{number of peptides}
\item{Correlation}{inter-peptide correlation coefficient}
\item{Direction}{direction of change}
\item{PValue}{raw p-value}
\item{adj.P.Val}{p-value adjusted via the Benjamini-Hochberg method}
}
\description{
Test whether peptides belonging to the same protein are differentially expressed relative to
the rest of the peptidome, accounting for inter-peptide correlation.
This function is adapted from \code{cameraPR()}
in LIMMA R package (Wu and Smyth (2012), \emph{Nucleic Acids Research}).
}
\examples{

y <- matrix(rnorm(1000 * 6), 1000, 6)
design <- cbind(Intercept = 1, Group = c(0, 0, 0, 1, 1, 1))

# First set of 20 genes are genuinely differentially expressed
index1 <- 1:20
y[index1, 4:6] <- y[index1, 4:6]+1

fit <- limma::eBayes(limma::lmFit(y, design))
TTestwCor(fit$t[, 2], index = index1,
inter.pep.cor = 0,
pepC.estim = "sd")

}
\references{
Wu, D, and Smyth, GK (2012). Camera: a competitive gene set test accounting for inter-gene correlation. \emph{Nucleic Acids Research} 40, e133
}
\author{
Junmin Wang
}
