% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rel_code_to_factor}
\alias{rel_code_to_factor}
\title{Relationship code variable to ordered factor}
\usage{
rel_code_to_factor(code)
}
\arguments{
\item{code}{A character, factor or numeric vector corresponding to
the relation code of the individuals:
\itemize{
\item MZ twin = Monozygotic twin
\item DZ twin = Dizygotic twin
\item UZ twin = twin of unknown zygosity
\item Spouse = Spouse
The following values are recognized:
\item character() or factor() : "MZ twin", "DZ twin", "UZ twin", "Spouse" with
of without space between the words. The case is not important.
\item numeric() : 1 = "MZ twin", 2 = "DZ twin", 3 = "UZ twin", 4 = "Spouse"
}}
}
\value{
an ordered factor vector containing the transformed variable
"MZ twin" < "DZ twin" < "UZ twin" < "Spouse"
}
\description{
Relationship code variable to ordered factor
}
\examples{
rel_code_to_factor(c(1, 2, 3, 4, "MZ twin", "DZ twin", "UZ twin", "Spouse"))
}
\keyword{internal}
