% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotPCAPlotly}
\alias{plotPCAPlotly}
\title{Plot PCA}
\usage{
plotPCAPlotly(df.input, condition.color.vec,
  condition.color.name = "condition", condition.shape.vec = NULL,
  condition.shape.name = "condition", columnTitle = "Title",
  pc.a = "PC1", pc.b = "PC2")
}
\arguments{
\item{df.input}{Input data object that contains
the data to be plotted. Required}

\item{condition.color.vec}{color vector. Required}

\item{condition.color.name}{color variable name. Required}

\item{condition.shape.vec}{shape vector. Required}

\item{condition.shape.name}{shape variable name. Required}

\item{columnTitle}{Title to be displayed at top of heatmap.}

\item{pc.a}{pc.1}

\item{pc.b}{pc.2}
}
\value{
the plot
}
\description{
Plot PCA
}
\examples{
data('iris')
plotPCAPlotly(t(iris[,1:4]),
condition.color.vec = c(rep(1,100), rep(0,50)),
condition.shape.vec = c(rep(0,100), rep(1,50)))
}
