% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialAnalysis.R
\name{phyloseq_to_edgeR}
\alias{phyloseq_to_edgeR}
\title{Convert phyloseq OTU count data into DGEList for edgeR package}
\usage{
phyloseq_to_edgeR(physeq, group, method = "RLE", ...)
}
\arguments{
\item{physeq}{(Required).}

\item{group}{(Required). A character vector or factor giving the experimental
group/condition for each sample/library.}

\item{method}{(Optional).}

\item{...}{Additional arguments passed on to}
}
\value{
dispersion
}
\description{
Further details.
}
\examples{
data_dir_test <- system.file("data", package = "PathoStat")
pstat_test <- loadPstat(indir=data_dir_test,
infileName="pstat_data_2_L1.rda")
phyloseq_to_edgeR(pstat_test, group="Sex")
}
