% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{TranslateIdToTaxLevel}
\alias{TranslateIdToTaxLevel}
\title{Find the taxonomy for the given taxon id name}
\usage{
TranslateIdToTaxLevel(pstat, input.id.vec, tax.level)
}
\arguments{
\item{pstat}{pathostat object}

\item{input.id.vec}{names containing id}

\item{tax.level}{target taxon level}
}
\value{
target taxon level names
}
\description{
Find the taxonomy for the given taxon id name
}
\examples{
data_dir_test <- system.file("data", package = "PathoStat")
pstat_test <- loadPstat(indir=data_dir_test,
infileName="pstat_data_2_L1.rda")
names.new <- TranslateIdToTaxLevel(pstat_test,
c("ti|862962|org|Bacteroides_fragilis_638R",
"ti|697329|org|Ruminococcus_albus_7" ),
"genus")
}
