% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialAnalysis.R
\name{Fisher_Test_Pam}
\alias{Fisher_Test_Pam}
\title{Given PAM and disease/control annotation,
do Chi-square test for each row of PAM}
\usage{
Fisher_Test_Pam(pam, label.vec.num, pvalue.cutoff = 0.05)
}
\arguments{
\item{pam}{Input data object that contains the data to be tested. Required}

\item{label.vec.num}{The target binary condition. Required}

\item{pvalue.cutoff}{choose p-value cut-off}
}
\value{
df.output object
}
\description{
Given PAM and disease/control annotation,
do Chi-square test for each row of PAM
}
\examples{
tmp <- matrix(rbinom(12,1,0.5), nrow = 3)
rownames(tmp) <- c("a", "b", "c")
Fisher_Test_Pam(tmp, c(1,1,0,0))
}
