% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pathwayGeneTab}
\alias{pathwayGeneTab}
\title{Pathway-Gene Associations}
\usage{
pathwayGeneTab(
  pathAdress = NA,
  pathwayList = NA,
  fromType = "ENTREZID",
  toType = "ENSEMBL",
  outDir = NA
)
}
\arguments{
\item{pathAdress}{Address to an RDS file containing list of pathways where
each element is a list of genes similar to GMT format.}

\item{pathwayList}{If you wish to use a list of pathways instead of a file
use this argument instead. The list must contain no NA values.}

\item{fromType}{gene annotation type used in your input data.}

\item{toType}{gene annotation type to be produced in the output.}

\item{outDir}{Address to save an RDS for a table of pathway-gene association}
}
\value{
pathExpTab Table of pathway-gene association.
}
\description{
Generates a table of pathways and genes associations.
}
\examples{
pathway1 <- c("125", "3099", "126")
pathway2 <- c("5232", "5230", "5162")
pathList <- list("Path1" = pathway1, "Path2" = pathway2)
res <- pathwayGeneTab(pathwayList = pathList)

data(msigdb_c2)
pathwayGeneTab(pathwayList = msigdb_c2[1:2])
}
