% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubsetSE.R
\name{remove_assays_from_SE}
\alias{remove_assays_from_SE}
\title{Remove normalization assays from a SummarizedExperiment object}
\usage{
remove_assays_from_SE(se, assays_to_remove)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{assays_to_remove}{Character vector of assay names to remove from the SummarizedExperiment object}
}
\value{
SummarizedExperiment object with the normalization assays removed
}
\description{
Remove normalization assays from a SummarizedExperiment object
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- remove_assays_from_SE(tuberculosis_TMT_se,
                                 assays_to_remove = c("IRS_on_RobNorm"))

}
