% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaUMAP.R
\name{PomaUMAP}
\alias{PomaUMAP}
\title{Dimensionality Reduction with UMAP}
\usage{
PomaUMAP(
  data,
  n_neighbors = floor(sqrt(nrow(data))),
  n_components = 2,
  metric = "euclidean",
  pca = NULL,
  min_dist = 0.01,
  spread = 1,
  hdbscan_minpts = floor(nrow(data) * 0.05),
  show_clusters = TRUE,
  hide_noise = TRUE,
  labels = FALSE,
  outcome = NULL,
  theme_params = list(legend_title = TRUE, legend_position = "bottom")
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{n_neighbors}{Numeric. Indicates the size of local neighborhood (sample points) used for manifold approximation.}

\item{n_components}{Numeric. Indicates the dimension of the space to embed into.}

\item{metric}{Character. Indicates the distance measure method to find nearest neighbors. Options are "euclidean", "cosine", "manhattan", "hamming" and "correlation". See \code{?uwot::umap()}.}

\item{pca}{If not NULL (default), reduce data to this number of columns using PCA before UMAP.}

\item{min_dist}{Numeric. Indicates the effective minimum distance between embedded points.}

\item{spread}{Numeric. Indicates the effective scale of embedded points.}

\item{hdbscan_minpts}{Numeric. Indicates the minimum size of clusters. See \code{?dbscan::hdbscan()}.}

\item{show_clusters}{Logical. Indicates if clusters computed with HDBSCAN method should be plotted or not.}

\item{hide_noise}{Logical. Specifies whether to hide Cluster 0 in the plot. In HDBSCAN, Cluster 0 is typically regarded as "noise."}

\item{labels}{Logical. Indicates if sample names should be plotted or not.}

\item{outcome}{Character. Has no effect on the analysis. Indicates the name of the \code{colData} column to be added to the output table. Default is NULL (no extra column added).}

\item{theme_params}{List. Indicates \code{theme_poma} parameters.}
}
\value{
A \code{list} with results including plots and tables.
}
\description{
\code{PomaUMAP} performs a dimension reduction of the data using the Uniform Manifold Approximation and Projection (UMAP) method. See \code{?uwot::umap()} for more.
}
\examples{
data <- POMA::st000284 # Example SummarizedExperiment object included in POMA

## Output is a list with objects `umap_embeddings` (tibble) and `umap_plot` (ggplot2 object)
data \%>\%
  PomaNorm() \%>\%
  PomaUMAP(metric = "euclidean",
           pca = NULL,
           min_dist = 0.01,
           spread = 1,
           hdbscan_minpts = floor(nrow(data) * 0.05),
           show_clusters = TRUE,
           hide_noise = TRUE,
           labels = FALSE,
           outcome = NULL)
}
\references{
McInnes, L., Healy, J., & Melville, J. (2018). Umap: Uniform manifold approximation and projection for dimension reduction. arXiv preprint arXiv:1802.03426.

Campello, R. J., Moulavi, D., & Sander, J. (2013, April). Density-based clustering based on hierarchical density estimates. In Pacific-Asia conference on knowledge discovery and data mining (pp. 160-172). Springer, Berlin, Heidelberg.
}
\author{
Pol Castellano-Escuder
}
