% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaPCR.R
\name{PomaPCR}
\alias{PomaPCR}
\title{Principal Components Regression}
\usage{
PomaPCR(data, center = TRUE, scale = TRUE, ncomp = 2, y = NULL, adjust = "fdr")
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{center}{Logical. Indicates whether the variables should be shifted to be zero centered. Default is TRUE.}

\item{scale}{Logical. Indicates whether the variables should be scaled to have unit variance before the analysis takes place. Default is TRUE.}

\item{ncomp}{Numeric. Indicates the number of principal components used as predictors in the model. Default is 2.}

\item{y}{Character. Indicates the name of \code{colData} columns to be used as dependent variable. If it's set to NULL, the first numeric variable in \code{colData} will be used as the dependent variable.}

\item{adjust}{Character. Multiple comparisons correction method to adjust p-values. Available options are: "fdr" (false discovery rate), "holm", "hochberg", "hommel", "bonferroni", "BH" (Benjamini-Hochberg), and "BY" (Benjamini-Yekutieli).}
}
\value{
A \code{tibble} with the results.
}
\description{
\code{PomaPCR} performs Principal Components Regression.
}
\examples{
data <- POMA::st000284 \%>\% # Example SummarizedExperiment object included in POMA
  PomaNorm()

# PCR with 2 components and the default outcome (1st column of `colData`)
data \%>\%
  PomaPCR(center = TRUE,
          scale = TRUE,
          ncomp = 2,
          y = NULL,
          adjust = "fdr")

# PCR with 2 components and alternative outcome
data \%>\%
  PomaPCR(center = TRUE,
          scale = TRUE,
          ncomp = 2,
          y = "age_at_consent",
          adjust = "fdr")

# PCR with 20 components and alternative outcome
data \%>\%
  PomaPCR(center = TRUE,
          scale = TRUE,
          ncomp = 20,
          y = "age_at_consent",
          adjust = "fdr")
}
\author{
Pol Castellano-Escuder
}
