% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPsScan.R
\name{runPsScan}
\alias{runPsScan}
\title{Run PS-Scan with Flexible Configuration}
\usage{
runPsScan(
  in_file,
  out_file,
  out_format = "scan",
  database_path = NULL,
  ps_scan_path = NULL,
  pfscan_path = NULL,
  os = NULL
)
}
\arguments{
\item{in_file}{Path to the input file containing protein sequences.}

\item{out_file}{Path for the output file where results will be saved.}

\item{out_format}{The output format for ps_scan (e.g., 'gff', 'psa', 'scan').}

\item{database_path}{(Optional) Path to the PROSITE database file (`prosite.dat`).
If NULL, the file is retrieved from the internal cache.}

\item{ps_scan_path}{(Optional) Path to the `ps_scan.pl` script.
If NULL, the file is retrieved from the internal cache.}

\item{pfscan_path}{(Optional) Path to the `pfscan` executable (or `pfscan.exe`).
If NULL, the file is retrieved from the internal cache (except on Mac, where it is optional).}

\item{os}{The operating system ('WIN', 'LINUX', 'MAC'). If NULL, it is
detected automatically.}
}
\value{
Invisibly returns the exit status of the ps_scan command. The primary
  output is the result file created at `out_file`.
}
\description{
This function runs the PROSITE ps_scan tool. It allows users to provide their
own paths to required files (database, script, executable). If paths are not
provided, it handles the downloading and caching of required executables and
databases using BiocFileCache.
}
