% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-sponge_data.r
\docType{data}
\name{sponge_data}
\alias{sponge_data}
\title{Sponge \emph{A. aerophoba} study}
\format{
A TreeSummarizedExperiment object containing the relative
abundance (Tss_value) and centered log ratio transformed values (Clr_value)
of 32 samples and 24 OTUs. The rowData includes \code{Y.trt} and
\code{Y.bat}. \code{Y.trt} is the effect of interest, which is a factor of
sponge tissues for each sample in the sponge study; \code{Y.bat} is the
batch effect, which is a factor of electrophoresis gels where each sample
processed. The rowTree is built based on the \code{Y.bat}.
}
\source{
The raw data were downloaded from the referenced article. Filtering
and normalisation described in
https://evayiwenwang.github.io/PLSDAbatch_workflow/.
}
\usage{
data('sponge_data')
}
\value{
None.
}
\description{
This study investigated the relationship between metabolite concentration
and microbial abundance of specific sponge tissues. The samples were
collected from two types of tissues (Ectosome vs. Choanosome) and processed
on two separate denaturing gradient gels in electrophoresis. This study
includes relative abundance data only and a completely balanced
batch x treatment design.
}
\references{
\insertRef{sacristan2011exploring}{PLSDAbatch}
}
\keyword{datasets}
