% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PICBbuild.R
\name{PICBbuild}
\alias{PICBbuild}
\title{Build piRNA seeds/cores/clusters from alignments}
\usage{
PICBbuild(
  IN.ALIGNMENTS,
  REFERENCE.GENOME,
  UNIQUEMAPPERS.SLIDING.WINDOW.WIDTH = 350,
  UNIQUEMAPPERS.SLIDING.WINDOW.STEP = round(UNIQUEMAPPERS.SLIDING.WINDOW.WIDTH/10, 0),
  PRIMARY.MULTIMAPPERS.SLIDING.WINDOW.WIDTH = 350,
  PRIMARY.MULTIMAPPERS.SLIDING.WINDOW.STEP =
    round(PRIMARY.MULTIMAPPERS.SLIDING.WINDOW.WIDTH/10, 0),
  SECONDARY.MULTIMAPPERS.SLIDING.WINDOW.WIDTH = 1000,
  SECONDARY.MULTIMAPPERS.SLIDING.WINDOW.STEP =
    round(SECONDARY.MULTIMAPPERS.SLIDING.WINDOW.WIDTH/10, 0),
  LIBRARY.SIZE = length(IN.ALIGNMENTS$unique) + length(IN.ALIGNMENTS$multi.primary),
  MIN.UNIQUE.ALIGNMENTS.PER.WINDOW = 2 * (UNIQUEMAPPERS.SLIDING.WINDOW.WIDTH/1000) *
    (LIBRARY.SIZE/1e+06),
  MIN.UNIQUE.SEQUENCES.PER.WINDOW = min(MIN.UNIQUE.ALIGNMENTS.PER.WINDOW,
    round(UNIQUEMAPPERS.SLIDING.WINDOW.WIDTH/50, 0)),
  MIN.PRIMARY.MULTIMAPPING.ALIGNMENTS.PER.WINDOW = 4 *
    (PRIMARY.MULTIMAPPERS.SLIDING.WINDOW.WIDTH/1000) * (LIBRARY.SIZE/1e+06),
  MIN.SECONDARY.MULTIMAPPING.ALIGNMENTS.PER.WINDOW = 0.2 *
    (SECONDARY.MULTIMAPPERS.SLIDING.WINDOW.WIDTH/1000) * (LIBRARY.SIZE/1e+06),
  MIN.SEED.LENGTH = 2 * UNIQUEMAPPERS.SLIDING.WINDOW.WIDTH + 100,
  MIN.COVERED.SEED.LENGTH = 0,
  THRESHOLD.SEEDS.GAP = 0,
  THRESHOLD.CORES.GAP = 0,
  THRESHOLD.CLUSTERS.GAP = 0,
  SEQ.LEVELS.STYLE = "UCSC",
  MIN.OVERLAP = 5,
  PROVIDE.NON.NORMALIZED = FALSE,
  COMPUTE.1U.10A.FRACTIONS = FALSE,
  VERBOSITY = 2
)
}
\arguments{
\item{IN.ALIGNMENTS}{list of alignments from PICBload}

\item{REFERENCE.GENOME}{name of genome. For example "BSgenome.Dmelanogaster.UCSC.dm6"}

\item{UNIQUEMAPPERS.SLIDING.WINDOW.WIDTH}{width of sliding window for unique mappers. 350 nt by default}

\item{UNIQUEMAPPERS.SLIDING.WINDOW.STEP}{step of sliding windows for unique mappers. width/10 by default}

\item{PRIMARY.MULTIMAPPERS.SLIDING.WINDOW.WIDTH}{width of sliding window for primary multimapping alignments. 350 nt by default}

\item{PRIMARY.MULTIMAPPERS.SLIDING.WINDOW.STEP}{step of sliding windows for primary multimapping alignments. width/10 by default}

\item{SECONDARY.MULTIMAPPERS.SLIDING.WINDOW.WIDTH}{width of sliding window for secondary multimapping alignments. 1000 nt by default}

\item{SECONDARY.MULTIMAPPERS.SLIDING.WINDOW.STEP}{step of sliding windows for secondary multimapping alignments. width/10 by default}

\item{LIBRARY.SIZE}{number of reads in the library. By default computed as number of unique mapping alignments + number of primary multimapping alignments.}

\item{MIN.UNIQUE.ALIGNMENTS.PER.WINDOW}{absolute number of unique mapping alignments per window to call it. By default computed as 2 FPKM.}

\item{MIN.UNIQUE.SEQUENCES.PER.WINDOW}{absolute number of unique mapping sequences per window to call it. By default computed as width/50.}

\item{MIN.PRIMARY.MULTIMAPPING.ALIGNMENTS.PER.WINDOW}{absolute number of primary multimapping alignments per window to call it. By default computed as 4 FPKM.}

\item{MIN.SECONDARY.MULTIMAPPING.ALIGNMENTS.PER.WINDOW}{absolute number of secondary multimapping alignments per window to call it. By default computed as 0.2 FPKM.}

\item{MIN.SEED.LENGTH}{minimum length of a seed. By default computed as 2x unique mapper window size + 100.}

\item{MIN.COVERED.SEED.LENGTH}{minimum number of seed nucleotides covered by unique mappers. 0 by default.}

\item{THRESHOLD.SEEDS.GAP}{minimum gap between seeds to not merge them. 0 by default.}

\item{THRESHOLD.CORES.GAP}{minimum gap between cores to not merge them. 0 by default.}

\item{THRESHOLD.CLUSTERS.GAP}{minimum gap between clusters to not merge them. 0 by default.}

\item{SEQ.LEVELS.STYLE}{naming of chromosomes style. "UCSC" by default.}

\item{MIN.OVERLAP}{minimum overlap between seeds and cores, as well as between cores and clusters 5 nt by default.}

\item{PROVIDE.NON.NORMALIZED}{include non-normalized to the library size statistics in the output annotations}

\item{COMPUTE.1U.10A.FRACTIONS}{for each locus and each alignments type (unique mapping, primary multimapping, secodnary multimapping) compute fraction 1U and 10A containing reads overlapping the locus. Default FALSE.}

\item{VERBOSITY}{verbosity level 0/1/2/3. 2 by default.}
}
\value{
list of annotated GRanges objects named "seeds" for seeds,
"cores" for cores,
"clusters" for clusters
}
\description{
Build piRNA seeds/cores/clusters from alignments
}
\examples{
library(BSgenome.Dmelanogaster.UCSC.dm6)
myAlignmentsFromPICBload <- PICBload(
    BAMFILE = system.file("extdata", "Fly_Ov1_chr2L_20To21mb_filtered.bam", package = "PICB"),
    REFERENCE.GENOME = "BSgenome.Dmelanogaster.UCSC.dm6",
    VERBOSE = FALSE
)

outputOfPICBbuild <- PICBbuild(
    IN.ALIGNMENTS = myAlignmentsFromPICBload,
    REFERENCE.GENOME = "BSgenome.Dmelanogaster.UCSC.dm6",
    VERBOSITY = 0
)
}
\author{
Pavol Genzor

Daniel Stoyko

Aleksandr Friman

Franziska Ahrend
}
