% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-validateModel.R
\name{validateModel,PCOSP_or_RLS_or_RGA,CohortList-method}
\alias{validateModel,PCOSP_or_RLS_or_RGA,CohortList-method}
\title{Evaluate the Performance of a List of Trained KTSP Models from a PCOSP
Model}
\usage{
\S4method{validateModel}{PCOSP_or_RLS_or_RGA,CohortList}(model, valData, ...)
}
\arguments{
\item{model}{A \code{PCOSP} model which has been trained using \code{trainModel}.}

\item{valData}{A \code{CohortList} containing one or more
\code{SurvivalExperiment}s. The first assay in each \code{SurvivalExperiment} will
be classified using all top scoring KTSP models in \code{models(model)}.}

\item{...}{Fallthrough arguments to \code{BiocParallel::bplapply}, use this to
configure the parallelization settings for this function. For example
to specify BPARAM.}
}
\value{
The \code{model} object with the validationStats and validationData
slots occupied.
}
\description{
Evaluate the Performance of a List of Trained KTSP Models from a PCOSP
Model
}
\examples{
data(sampleTrainedPCOSPmodel)
data(samplePCOSPpredList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Validate model
validatedPCOSPmodel <- validateModel(sampleTrainedPCOSPmodel,
  valData=samplePCOSPpredList)

}
\seealso{
\code{\link[BiocParallel:bplapply]{BiocParallel::bplapply}}, \code{\link[switchBox:SWAP.KTSP.Classify]{switchBox::SWAP.KTSP.Classify}}
}
