% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-getTopFeatures.R
\name{getTopFeatures,PCOSP-method}
\alias{getTopFeatures,PCOSP-method}
\title{Get the top features for classification using a PCOSP model object.}
\usage{
\S4method{getTopFeatures}{PCOSP}(object, numModels)
}
\arguments{
\item{object}{A \code{PCOSP} model object which has been trained with \code{trainModel}.}

\item{numModels}{An \code{integer} specifying the number of top models to
use features from. Defaults to top 10\% of KTSPs models.}
}
\value{
A \code{character} vector of gene names representing the unique genes
from the top \code{numModels} KTSPs models in the model \code{object}.
}
\description{
Get the top features for classification using a PCOSP model object.
}
\examples{
data(sampleTrainedPCOSPmodel)

# Get the top features
topFeatures <- getTopFeatures(sampleTrainedPCOSPmodel, numModels=5)

}
