% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-assignSubtypes.R
\name{assignSubtypes}
\alias{assignSubtypes}
\title{Assign Sample Subtypes to an S4 Object}
\usage{
assignSubtypes(object, subtypes, ...)
}
\arguments{
\item{object}{An \code{S4} object containing a slot representing samples or patients.}

\item{subtypes}{A mapping to assign subtypes to the samples or patients in
the object.}

\item{...}{Allow new parameters to be defined for this generic.}
}
\value{
object with subtypes assigned to the sample metadata and the
isSubtyped metadata item set to TRUE.
}
\description{
Assign Sample Subtypes to an S4 Object
}
\examples{
data(sampleICGCmicro)
data(cohortSubtypeDFs)

cohortList <- assignSubtypes(sampleICGCmicro,
  subtypes=cohortSubtypeDFs$ICGCMICRO,
  sampleCol='sample_name',
  subtypeCol='subtype')

}
