% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-SurvivalModel.R
\docType{class}
\name{SurvivalModel-class}
\alias{SurvivalModel-class}
\alias{.SurvivalModel}
\title{A Generic Container for Storing Mathematical Models of SurvivalExperiments}
\description{
An S4 class with a number of predefined methods for
accessing slots relavant to a surival model. More specific model types
will inherit from this class for their accessor methods and constructor.
}
\section{Slots}{

\describe{
\item{\code{models}}{A \code{SimpleList} containing one or more model object.}

\item{\code{validationData}}{A \code{CohortList} containing one or more \code{SurvivalExperiment}
objects used to validate the model. This slot is populated by the when the
\code{validateModel} method is called on a \code{SurvivalModel} object.}

\item{\code{validationStats}}{A \code{data.frame} object containing validation statistics
calculated by the \code{validateModel} method.}
}}

\examples{
data(sampleICGCmicro)
set.seed(1987)
survModel <- SurvivalModel(sampleICGCmicro, minDaysSurvived=385,
  randomSeed=1987)

}
