% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PipeShiftCDF.R
\name{PipeShiftCDF}
\alias{PipeShiftCDF}
\title{Calculate residual of the sliding polynomial regression}
\usage{
PipeShiftCDF(Data, Ndg=3, NChun=4, RdmStart=FALSE)
}
\arguments{
\item{Data}{gene-by-sample matrix or isoform-by-sample matrix. It should be rescaled to values bwteen
[-1,1].}

\item{Ndg}{degree of polynomial.}

\item{NChun}{number of starting points for polynomial fitting.}

\item{RdmStart}{whether the start points are randomly selected.}
}
\value{
The function will fit sliding polynomial regression  (SPR)
to each row of the data.
For each gene/isoform, SPR fits NChun polynomial curves with different starting
points (samples). The samples with smaller order than the start point will be appended
to follow the last sample when fitting. So each fitting consider same number
 of samples. If RdmStart = TRUE, the start points are randomly selected.
Otherwise they are evenly sampled along the sample order.
The aggregated MSE of a fit (using a specific start point) is defined as the
summation of the MSEs of all genes/isoforms considered here.
The output returns the MSE of the SPR, which is the largest aggregated MSE across fits
using different start points.
}
\description{
Calculate residual of the sliding polynomial regression
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
cc <- sin(seq(0.9,1.9,.1))
res <- PipeShiftCDF(rbind(aa,bb,cc), NChun=2)
}
\author{
Ning Leng
}

