% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FormatSineOut.R
\name{FormatSineOut}
\alias{FormatSineOut}
\title{Format SinFun outputs from lists to matrix}
\usage{
FormatSineOut(result, DataInSc, ShiftRg=pi/4)
}
\arguments{
\item{result}{Output from SineFun}

\item{DataInSc}{a gene-by-sample (isoform-by-sample) matrix indicating the rescaled expression of two genes/isoforms.
all values should be bettwen [-1, 1].}

\item{ShiftRg}{phase shift cutoff.}
}
\value{
Output is a list with 4 sublists, each shows a N-by-N matrix, in which#' N is the total number of genes (isoforms).
SimiMat: similarity matrix (sine scores); the sine scores are calculated
by -log10(epsilon^2).
DiffMat: dissimilarity matrix; shown are epsilon^2 for each gene pair.
ShiftMat: optimal phase shift estimate for each pair of genes.
}
\description{
Format SinFun outputs from lists to matrix
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
cc <- sin(seq(0.9,1.9,.1))
DataInSc <- rbind(aa,bb,cc)
NumGene <- nrow(DataInSc)
Res <- sapply(1:(NumGene-1),function(i)SineFun(DataInSc, i),simplify=FALSE)
Out <- FormatSineOut(Res, DataInSc)
}
\author{
Ning Leng
}

