% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{relations_table_to_graph}
\alias{relations_table_to_graph}
\title{Graph from a table of ontology relations}
\usage{
relations_table_to_graph(relations)
}
\arguments{
\item{relations}{A data frame of ontology relations (the "relations"
element of the list returned by \code{\link{obo_parser}} in case
its argument `tables` is \code{TRUE}).}
}
\value{
The relations converted to an igraph graph object.
}
\description{
Graph from a table of ontology relations
}
\details{
By default the relations point from child to parents, the edges in the
graph will be of the same direction. Use \code{\link{swap_relations}}
on the data frame to reverse the direction.
}
\examples{
\dontrun{
go <- get_db('go_basic')
go_graph <- relations_table_to_graph(go$relations)
}

}
