% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{omnipath_cache_update_status}
\alias{omnipath_cache_update_status}
\title{Updates the status of an existing cache record}
\usage{
omnipath_cache_update_status(key, version, status,
    dl_finished = NULL)
}
\arguments{
\item{key}{Key of the cache item}

\item{version}{Version of the cache item. If does not exist a new version
item will be created}

\item{status}{The updated status value}

\item{dl_finished}{Timestamp for the time when download was finished,
if `NULL` the value remains unchanged}
}
\value{
Character: invisibly returns the version number of the cache
    version item.
}
\description{
Updates the status of an existing cache record
}
\examples{
bioc_url <- 'https://bioconductor.org/'
latest_version <- omnipath_cache_latest_or_new(url = bioc_url)
key <- omnipath_cache_key(bioc_url)
omnipath_cache_update_status(
    key = key,
    version = latest_version$number,
    status = 'ready',
    dl_finished = Sys.time()
)
omnipath_cache_remove(url = bioc_url) # cleaning up

}
