% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_build_model}
\alias{nichenet_build_model}
\title{Construct a NicheNet ligand-target model}
\usage{
nichenet_build_model(optimization_results, networks, use_weights = TRUE)
}
\arguments{
\item{optimization_results}{The outcome of NicheNet parameter optimization
as produced by \code{\link{nichenet_optimization}}.}

\item{networks}{A list with NicheNet format signaling, ligand-receptor
and gene regulatory networks as produced by
\code{\link{nichenet_networks}}.}

\item{use_weights}{Logical: whether to use the optimized weights.}
}
\value{
A named list with two elements: `weighted_networks` and
    `optimized_parameters`.
}
\description{
Construct a NicheNet ligand-target model
}
\examples{
\dontrun{
expression <- nichenet_expression_data()
networks <- nichenet_networks()
optimization_results <- nichenet_optimization(networks, expression)
nichenet_model <- nichenet_build_model(optimization_results, networks)
}

}
