% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homologene.R
\name{homologene_download}
\alias{homologene_download}
\title{Orthology table for a pair of organisms}
\usage{
homologene_download(
  target = 10090L,
  source = 9606L,
  id_type = "genesymbol",
  hgroup_size = FALSE
)
}
\arguments{
\item{target}{Character or integer: name or ID of the target organism.}

\item{source}{Character or integer: name or ID of the source organism.}

\item{id_type}{Symbol or character: identifier type, possible values are
"genesymbol", "entrez", "refseqp" or "gi".}

\item{hgroup_size}{Logical: include a column with the size of the homology
groups. This column distinguishes one-to-one and one-to-many or
many-to-many mappings.}
}
\value{
A data frame with orthologous identifiers between the two organisms.
}
\description{
Orthologous pairs of genes for a pair of organisms from NCBI HomoloGene,
using one identifier type.
}
\details{
The operation of this function is symmetric, *source* and *target* are
interchangeable but determine the column layout of the output. The column
"hgroup" is a numberic identifier of the homology groups. Most of the
groups consist of one pair of orthologous genes (one-to-one mapping), and
a few of them multiple ones (one-to-many or many-to-many mappings).
}
\examples{
chimp_human <- homologene_download(chimpanzee, human, refseqp)
chimp_human
# # A tibble: 17,737 × 3
#    hgroup refseqp_source refseqp_target
#     <int> <chr>          <chr>
#  1      3 NP_000007.1    NP_001104286.1
#  2      5 NP_000009.1    XP_003315394.1
#  3      6 NP_000010.1    XP_508738.2
#  4      7 NP_001096.1    XP_001145316.1
#  5      9 NP_000014.1    XP_523792.2
# # . with 17,732 more rows

}
\seealso{
\itemize{
    \item{\code{\link{homologene_raw}}}
    \item{\code{\link{homologene_uniprot_orthology}}}
}
}
