% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensembl.R
\name{biomart_query}
\alias{biomart_query}
\title{Query the Ensembl BioMart web service}
\usage{
biomart_query(
  attrs = NULL,
  filters = NULL,
  transcript = FALSE,
  peptide = FALSE,
  gene = FALSE,
  dataset = "hsapiens_gene_ensembl"
)
}
\arguments{
\item{attrs}{Character vector: one or more Ensembl attribute names.}

\item{filters}{Character vector: one or more Ensembl filter names.}

\item{transcript}{Logical: include Ensembl transcript IDs in the result.}

\item{peptide}{Logical: include Ensembl peptide IDs in the result.}

\item{gene}{Logical: include Ensembl gene IDs in the result.}

\item{dataset}{Character: An Ensembl dataset name.}
}
\value{
Data frame with the query result
}
\description{
Query the Ensembl BioMart web service
}
\examples{
cel_genes <- biomart_query(
    attrs = c("external_gene_name", "start_position", "end_position"),
    gene = TRUE,
    dataset = "celegans_gene_ensembl"
)
cel_genes
# # A tibble: 46,934 × 4
#   ensembl_gene_id external_gene_name start_position end_position
#   <chr>           <chr>                       <dbl>        <dbl>
# 1 WBGene00000001  aap-1                     5107843      5110183
# 2 WBGene00000002  aat-1                     9599178      9601695
# 3 WBGene00000003  aat-2                     9244402      9246360
# 4 WBGene00000004  aat-3                     2552260      2557736
# 5 WBGene00000005  aat-4                     6272529      6275721
# # . with 46,924 more rows

}
