% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalueWeightedEst.R
\name{pvalueWeightedEst}
\alias{pvalueWeightedEst}
\title{p-value by weighted permutation scheme}
\usage{
pvalueWeightedEst(tt, ttperm, w)
}
\arguments{
\item{tt}{a vector of test statistics.}

\item{ttperm}{a matrix of test statistics from permutations.
Rows correspond to probes and columns to one permutation.}

\item{w}{a matrix containing weights for each spot in \code{ttperm}.
Provided by \code{\link{postProbNull}}.}
}
\value{
p-values.
}
\description{
This function estimates p-values by aggregating weighted permutations.
}
\details{
P-values are estimated by weightedly accumulating test statistics
from permutations that are larger than observations
}
\examples{
#generate some example data
t.obs <- rnorm(100)
t.perm <- matrix(rnorm(100*1000),nrow=100)
w <- matrix(runif(100*1000),nrow=100)

pv <- pvalueWeightedEst(t.obs, t.perm, w)
}
