% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R, R/getNSetterFuns.R
\name{getBestQ}
\alias{getBestQ}
\alias{getter_setter_functions}
\alias{zScore,}
\alias{pValue,}
\alias{padj,}
\alias{theta,}
\alias{dispersion,}
\alias{zScore}
\alias{pValue}
\alias{padj}
\alias{dispersions,OutriderDataSet-method}
\alias{dispersions}
\alias{theta}
\title{Getter/Setter functions}
\usage{
getBestQ(ods)

zScore(ods)

pValue(ods)

padj(ods, subsetName = NULL)

\S4method{dispersions}{OutriderDataSet}(object, ...)

theta(ods)
}
\arguments{
\item{ods, object}{An OutriderDataSet object.}

\item{subsetName}{Name of a gene subset for which to store or retrieve 
FDR corrected p values}

\item{...}{Further arguments passed on to the underlying assay function.}
}
\value{
A matrix or vector dependent on the type of data retrieved.
}
\description{
This is a collection of small accessor/setter functions for easy access to
the values within the OUTRIDER model.
}
\examples{
ods <- makeExampleOutriderDataSet(10, 10)
ods <- OUTRIDER(ods)

zScore(ods)
pValue(ods)
padj(ods)
theta(ods)
theta(ods) == 1/dispersions(ods)
getBestQ(ods)

}
\seealso{
\code{\link[DESeq2]{estimateDispersions}}
}
