% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZscoreMatrix.R
\docType{methods}
\name{computeZscores}
\alias{computeZscores}
\alias{computeZscores,OutriderDataSet-method}
\title{Z score computation}
\usage{
computeZscores(ods, ...)

\S4method{computeZscores}{OutriderDataSet}(ods, peerResiduals = FALSE, ...)
}
\arguments{
\item{ods}{OutriderDataSet}

\item{...}{Further arguments passed on to \code{ZscoreMatrix}.}

\item{peerResiduals}{If TRUE, PEER residuals are used to compute Z scores}
}
\value{
An OutriderDataSet containing the Z score matrix "zScore" and
    the log2 fold changes "l2fc" as asasys.
}
\description{
Computes the z scores for every count in the matrix.
The z score is defined in the log\eqn{_2}{[2]} space as follows:
\eqn{z_{ij} = \frac{l_{ij} - \mu_j^l}{
     \sigma_j^l}}{z_ij = (l[ij] - mu[j]^l)/sigma[ij]}
where \code{l} is the log\eqn{_2}{[2]} transformed normalized count and 
\eqn{\mu}{mu} and \eqn{\sigma}{sigma} the mean and standard deviation 
for gene \code{j} and sample \code{i}, respectively.
}
\examples{
ods <- makeExampleOutriderDataSet()
ods <- estimateSizeFactors(ods)

ods <- controlForConfounders(ods, implementation="pca")
ods <- computeZscores(ods)

zScore(ods)[1:10,1:10]
assay(ods, "l2fc")[1:10,1:10]

}
