% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_footprints_helpers.R
\name{ribo_fft_plot}
\alias{ribo_fft_plot}
\title{Get periodogram plot per read length}
\usage{
ribo_fft_plot(fft_dt, period_window = c(0, 6))
}
\arguments{
\item{fft_dt}{a data.table with read_length, amplitude and periods}

\item{period_window}{x axis limits, default c(0,6)}
}
\value{
a ggplot, geom_line plot facet by read length.
}
\description{
Get periodogram plot per read length
}
\examples{
## Note, this sample data is not intended to be strongly periodic.
## Real data should have a cleaner peak for x = 3 (periodicity)
# Load sample data
df <- ORFik.template.experiment()
# Load annotation
cds <- loadRegion(df, "cds", names.keep = filterTranscripts(df))
# Select a riboseq library
df <- df[df$libtype == "RFP", ]
footprints <- fimport(filepath(df[1,], "default"))
fft_dt <-ribo_fft(footprints, cds)
ribo_fft_plot(fft_dt)
}
