% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_helpers.R
\name{firstExonPerGroup}
\alias{firstExonPerGroup}
\title{Get first exon per GRangesList group}
\usage{
firstExonPerGroup(grl)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}}}
}
\value{
a GRangesList of the first exon per group
}
\description{
grl must be sorted, call ORFik:::sortPerGroup if needed
}
\examples{
gr_plus <- GRanges(seqnames = c("chr1", "chr1"),
                   ranges = IRanges(c(7, 14), width = 3),
                   strand = c("+", "+"))
gr_minus <- GRanges(seqnames = c("chr2", "chr2"),
                    ranges = IRanges(c(4, 1), c(9, 3)),
                    strand = c("-", "-"))
grl <- GRangesList(tx1 = gr_plus, tx2 = gr_minus)
firstExonPerGroup(grl)
}
